<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Transaction;
use App\Models\Payment;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class HistoryController extends Controller
{
    public function index(Request $request)
    {
        $userId = auth()->user()->id;  // Changed to auth()->user()->id to get the integer ID
        $query = $request->input('search');

        $transactions = Transaction::select(
            'transactions.id as id',
            'transactions.type',
            DB::raw('CAST(transactions.amount AS DECIMAL(15,2)) as amount'),
            'transactions.source',
            'categories.name as related_entity',
            'transactions.description',
            'transactions.images',
            'transactions.is_cancelled',
            'transactions.cancelled_at',
            'transactions.created_at',
            DB::raw("'transactions' as source_table"),
            DB::raw('NULL as supplier_name'),
            'users.name as user_name'
        )
        ->leftJoin('categories', 'transactions.category_id', '=', 'categories.id')
        ->join('users', 'transactions.user_id', '=', 'users.id')
        ->where('transactions.user_id', $userId);

        $payments = Payment::select(
            'payments.id as id',
            'payments.type',
            DB::raw('CAST(payments.amount AS DECIMAL(15,2)) as amount'),
            'payments.source',
            'suppliers.name as related_entity',
            'payments.description',
            'payments.images',
            'payments.is_cancelled',
            'payments.cancelled_at',
            'payments.created_at',
            DB::raw("'payments' as source_table"),
            'suppliers.name as supplier_name',
            'users.name as user_name'
        )
        ->join('suppliers', 'payments.supplier_id', '=', 'suppliers.id')
        ->join('users', 'payments.user_id', '=', 'users.id')
        ->where('payments.user_id', $userId);

        $combined = $transactions->union($payments);

        if ($query) {
            $combined = $combined->where(function ($q) use ($query) {
                $q->where('description', 'like', "%{$query}%")
                  ->orWhere('source', 'like', "%{$query}%")
                  ->orWhere('related_entity', 'like', "%{$query}%")
                  ->orWhere(DB::raw('CAST(amount AS CHAR)'), 'like', "%{$query}%")
                  ->orWhere('users.name', 'like', "%{$query}%");
            });
        }

        $results = $combined->orderBy('created_at', 'desc')->paginate(10);

        // created_at va cancelled_at ni Carbon obyekti sifatida ta'minlash
        $results->getCollection()->transform(function ($item) {
            $item->created_at = Carbon::parse($item->created_at);
            $item->cancelled_at = $item->cancelled_at ? Carbon::parse($item->cancelled_at) : null;
            return $item;
        });

        return view('history.index', compact('results', 'query'));
    }
}