<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateCategoriesTable extends Migration
  {
      public function up()
      {
          Schema::create('categories', function (Blueprint $table) {
              $table->id();
              $table->string('name');
              $table->timestamps();
          });

          // Initial standard categories for Transit Expenses and Income
          \App\Models\Category::create(['name' => 'Kassadan']);
          \App\Models\Category::create(['name' => 'Tashqi mablag\'']);
          \App\Models\Category::create(['name' => 'Savdo']);
          \App\Models\Category::create(['name' => 'Boshqa']);
      }

      public function down()
      {
          Schema::dropIfExists('categories');
      }
  }