<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->boolean('is_cancelled')->default(false)->after('images');
            $table->timestamp('cancelled_at')->nullable()->after('is_cancelled');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->boolean('is_cancelled')->default(false)->after('images');
            $table->timestamp('cancelled_at')->nullable()->after('is_cancelled');
        });
    }

    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn(['is_cancelled', 'cancelled_at']);
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn(['is_cancelled', 'cancelled_at']);
        });
    }
};