import 'bootstrap/dist/js/bootstrap.bundle.min.js';
import numeral from 'numeral';

// Register the space-separated format
numeral.register('locale', 'uz', {
    delimiters: {
        thousands: ' ',
        decimal: ','
    },
    abbreviations: {
        thousand: 'k',
        million: 'm',
        billion: 'b',
        trillion: 't'
    },
    currency: {
        symbol: 'so\'m'
    }
});

// Set the locale to 'uz'
numeral.locale('uz');

window.numeral = numeral;
window.formatNumber = (num) => {
    const parsed = parseFloat(num);
    return isNaN(parsed) ? num : numeral(parsed).format('0,0');
};

// Camera and gallery functionality
document.addEventListener('DOMContentLoaded', () => {
    const forms = [
        { id: 'income', buttonId: 'capture-image-income', selectButtonId: 'select-image-income', inputId: 'income_images', previewId: 'income_images_preview', fileCountId: 'income_file_count' },
        { id: 'expense', buttonId: 'capture-image-expense', selectButtonId: 'select-image-expense', inputId: 'expense_images', previewId: 'expense_images_preview', fileCountId: 'expense_file_count' },
        { id: 'payment-to-supplier', buttonId: 'capture-image-payment-to-supplier', selectButtonId: 'select-image-payment-to-supplier', inputId: 'payment_images', previewId: 'payment_images_preview', fileCountId: 'payment_file_count' },
        { id: 'product-payment', buttonId: 'capture-image-product-payment', selectButtonId: 'select-image-product-payment', inputId: 'product_images', previewId: 'product_images_preview', fileCountId: 'product_file_count' }
    ];

    const maxFiles = 12; // Maksimal 12 ta rasm

    forms.forEach(form => {
        const captureBtn = document.getElementById(form.buttonId);
        const selectBtn = document.getElementById(form.selectButtonId);
        const fileInput = document.getElementById(form.inputId);
        const previewDiv = document.getElementById(form.previewId);
        const fileCountDisplay = document.getElementById(form.fileCountId);

        if (!captureBtn || !fileInput || !previewDiv || !fileCountDisplay) {
            console.error(`${form.id} Form: One or more elements not found`);
            return;
        }

        // Fayllar sonini yangilash
        function updateFileCount() {
            const count = fileInput.files.length;
            fileCountDisplay.textContent = `Tanlangan fayllar: ${count}`;
            captureBtn.disabled = count >= maxFiles;
            if (selectBtn) selectBtn.disabled = count >= maxFiles;
        }

        // Kamera orqali rasmga olish
        function startCamera() {
            if (fileInput.files.length >= maxFiles) {
                alert(`Faqat ${maxFiles} ta rasm yuklash mumkin!`);
                return;
            }

            navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
                .then(stream => {
                    const modal = document.createElement('div');
                    modal.style.position = 'fixed';
                    modal.style.top = '0';
                    modal.style.left = '0';
                    modal.style.width = '100%';
                    modal.style.height = '100%';
                    modal.style.backgroundColor = 'rgba(0,0,0,0.9)';
                    modal.style.zIndex = '9999';
                    modal.style.display = 'flex';
                    modal.style.flexDirection = 'column';
                    modal.style.alignItems = 'center';
                    modal.style.justifyContent = 'center';

                    const video = document.createElement('video');
                    video.style.maxWidth = '90%';
                    video.style.maxHeight = '70%';
                    video.autoplay = true;
                    video.playsInline = true;
                    video.srcObject = stream;

                    const captureBtn = document.createElement('button');
                    captureBtn.textContent = 'Rasmga olish';
                    captureBtn.className = 'btn btn-success btn-lg mt-3';
                    captureBtn.style.minWidth = '200px';

                    const closeBtn = document.createElement('button');
                    closeBtn.textContent = 'Yopish';
                    closeBtn.className = 'btn btn-danger btn-lg mt-2';
                    closeBtn.style.minWidth = '200px';

                    modal.appendChild(video);
                    modal.appendChild(captureBtn);
                    modal.appendChild(closeBtn);
                    document.body.appendChild(modal);

                    captureBtn.onclick = () => {
                        const canvas = document.createElement('canvas');
                        canvas.width = video.videoWidth;
                        canvas.height = video.videoHeight;
                        canvas.getContext('2d').drawImage(video, 0, 0);

                        canvas.toBlob(blob => {
                            const fileName = `capture-${Date.now()}.jpg`;
                            const file = new File([blob], fileName, { type: 'image/jpeg' });

                            const dt = new DataTransfer();
                            Array.from(fileInput.files).forEach(f => dt.items.add(f));
                            dt.items.add(file);

                            if (dt.files.length > maxFiles) {
                                alert(`Faqat ${maxFiles} ta rasm yuklash mumkin!`);
                                return;
                            }

                            fileInput.files = dt.files;

                            const reader = new FileReader();
                            reader.onload = e => {
                                const div = document.createElement('div');
                                div.style.position = 'relative';
                                div.style.display = 'inline-block';
                                div.style.margin = '5px';

                                const img = document.createElement('img');
                                img.src = e.target.result;
                                img.style.maxWidth = '100px';
                                img.style.borderRadius = '8px';
                                img.style.boxShadow = '0 2px 8px rgba(0,0,0,0.2)';

                                const del = document.createElement('button');
                                del.textContent = 'x';
                                del.style.position = 'absolute';
                                del.style.top = '0';
                                del.style.right = '0';
                                del.style.background = 'red';
                                del.style.color = 'white';
                                del.style.border = 'none';
                                del.style.borderRadius = '50%';
                                del.style.width = '24px';
                                del.style.height = '24px';
                                del.style.fontSize = '16px';
                                del.onclick = () => {
                                    const dt2 = new DataTransfer();
                                    Array.from(fileInput.files)
                                        .filter(f => f.name !== fileName)
                                        .forEach(f => dt2.items.add(f));
                                    fileInput.files = dt2.files;
                                    div.remove();
                                    updateFileCount();
                                };

                                div.appendChild(img);
                                div.appendChild(del);
                                previewDiv.appendChild(div);
                            };
                            reader.readAsDataURL(file);

                            updateFileCount();
                        }, 'image/jpeg', 0.9);
                    };

                    closeBtn.onclick = () => {
                        stream.getTracks().forEach(t => t.stop());
                        document.body.removeChild(modal);
                    };
                })
                .catch(err => {
                    console.error('Kamera xatosi:', err);
                    alert('Kamera ishga tushmadi. Galereyadan tanlang.');
                });
        }

        // Galereyadan 12 tagacha rasm tanlash — ASOSIY YECHIM
        if (selectBtn) {
            selectBtn.addEventListener('click', () => {
                if (fileInput.files.length >= maxFiles) {
                    alert(`Faqat ${maxFiles} ta rasm yuklash mumkin!`);
                    return;
                }

                // Muhim: multiple atributini majburiy qilish
                fileInput.setAttribute('multiple', 'multiple');
                // capture ni olib tashlash — galereya rejimi
                fileInput.removeAttribute('capture');
                // oldingi tanlovni tozalamaymiz — saqlab qolamiz
                fileInput.value = '';

                // Fayl tanlash oynasini ochish
                fileInput.click();
            });
        }

        // Fayl tanlanganda (kamera yoki galereya)
        fileInput.addEventListener('change', () => {
            const newFiles = Array.from(fileInput.files);

            if (fileInput.files.length > maxFiles) {
                alert(`Faqat ${maxFiles} ta rasm yuklash mumkin!`);
                fileInput.value = '';
                previewDiv.innerHTML = '';
                updateFileCount();
                return;
            }

            // Mavjud fayllarni saqlab qolish
            const dt = new DataTransfer();
            Array.from(fileInput.files).forEach(f => {
                if (f.type.startsWith('image/')) dt.items.add(f);
            });

            // Yangi fayllarni qo‘shish
            newFiles.forEach(file => {
                if (file.type.startsWith('image/') && dt.files.length < maxFiles) {
                    dt.items.add(file);
                }
            });

            fileInput.files = dt.files;

            // Oldindan ko‘rishni tozalab, qayta yaratish
            previewDiv.innerHTML = '';
            Array.from(fileInput.files).forEach((file, index) => {
                const reader = new FileReader();
                reader.onload = e => {
                    const div = document.createElement('div');
                    div.style.position = 'relative';
                    div.style.display = 'inline-block';
                    div.style.margin = '5px';

                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.style.maxWidth = '100px';
                    img.style.borderRadius = '8px';
                    img.style.boxShadow = '0 2px 8px rgba(0,0,0,0.2)';

                    const del = document.createElement('button');
                    del.textContent = 'x';
                    del.style.position = 'absolute';
                    del.style.top = '0';
                    del.style.right = '0';
                    del.style.background = 'red';
                    del.style.color = 'white';
                    del.style.border = 'none';
                    del.style.borderRadius = '50%';
                    del.style.width = '24px';
                    del.style.height = '24px';
                    del.style.fontSize = '16px';
                    del.onclick = () => {
                        const dt2 = new DataTransfer();
                        Array.from(fileInput.files)
                            .filter((_, i) => i !== index)
                            .forEach(f => dt2.items.add(f));
                        fileInput.files = dt2.files;
                        div.remove();
                        updateFileCount();
                    };

                    div.appendChild(img);
                    div.appendChild(del);
                    previewDiv.appendChild(div);
                };
                reader.readAsDataURL(file);
            });

            updateFileCount();
        });

        // Kamera tugmasi
        captureBtn.addEventListener('click', startCamera);

        // Boshlang‘ich holat
        updateFileCount();
    });
});