@extends('layouts.app')
@section('title', 'Yangi kategoriya qo‘shish')

@section('content')
<div class="container mt-4" style="padding-bottom: 50px;">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Yangi kategoriya qo‘shish</h5>
        </div>
        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('categories.store') }}">
                @csrf
                <div class="mb-3">
                    <label for="name" class="form-label">Kategoriya nomi</label>
                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="type" class="form-label">Turi</label>
                    <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" required>
                        <option value="expense" {{ old('type') == 'expense' ? 'selected' : '' }}>Xarajat</option>
                        <option value="other" {{ old('type') == 'other' ? 'selected' : '' }}>Boshqa</option>
                    </select>
                    @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary">Saqlash</button>
                <a href="{{ route('categories.index') }}" class="btn btn-secondary ms-2">Bekor qilish</a>
            </form>
        </div>
    </div>
</div>
@endsection