<!DOCTYPE html>
<html lang="uz" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'PayPul')</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <style>
        :root[data-theme="dark"] {
            --bg-color: #1a1a1a;
            --text-color: #e0e0e0;
            --card-bg: #2d2d2d;
            --border-color: #444;
            --alert-bg: #2d2d2d;
            --alert-success-bg: #1a3a1a;
            --alert-danger-bg: #3a1a1a;
            --input-bg: #2d2d2d;
            --input-text: #e0e0e0;
            --button-bg: #28a745;
            --button-hover-bg: #218838;
            --nav-bg: #1a1a1a;
            --nav-link: #e0e0e0;
            --nav-link-hover: #28a745;
            --pagination-bg: #2d2d2d;
            --pagination-text: #e0e0e0;
            --pagination-active-bg: #28a745;
            --pagination-disabled: #6c757d;
        }
        :root[data-theme="light"] {
            --bg-color: #ffffff;
            --text-color: #212529;
            --card-bg: #f8f9fa;
            --border-color: #dee2e6;
            --alert-bg: #f8f9fa;
            --alert-success-bg: #d4edda;
            --alert-danger-bg: #f8d7da;
            --input-bg: #ffffff;
            --input-text: #212529;
            --button-bg: #28a745;
            --button-hover-bg: #218838;
            --nav-bg: #ffffff;
            --nav-link: #212529;
            --nav-link-hover: #28a745;
            --pagination-bg: #f8f9fa;
            --pagination-text: #212529;
            --pagination-active-bg: #28a745;
            --pagination-disabled: #6c757d;
        }
        body {
            background-color: var(--bg-color);
            color: var(--text-color);
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            transition: all 0.3s ease;
        }
        .content {
            flex: 1;
        }
        .calculator-keypad {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 6px;
            max-width: 100%;
            margin-top: 8px;
            padding: 10px;
            background: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .calculator-keypad button {
            padding: 14px;
            font-size: 24px;
            font-weight: 400;
            border: none;
            border-radius: 50%;
            background-color: var(--input-bg);
            color: var(--input-text);
            cursor: pointer;
            transition: background-color 0.2s, transform 0.1s;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        .calculator-keypad button:hover {
            background-color: var(--pagination-bg);
            transform: translateY(-1px);
        }
        .calculator-keypad button:active {
            background-color: var(--border-color);
            transform: translateY(0);
        }
        .calculator-keypad .operator-btn {
            background-color: #ff9500;
            color: white;
        }
        .calculator-keypad .operator-btn:hover {
            background-color: #e68a00;
        }
        .calculator-keypad .operator-btn:active {
            background-color: #cc7a00;
        }
        .calculator-keypad .zero-btn {
            grid-column: span 2;
            border-radius: 50px;
        }
        .calculator-keypad .clear-btn {
            background-color: #a5a5a5;
            color: var(--input-text);
        }
        .calculator-keypad .clear-btn:hover {
            background-color: #8f8f8f;
        }
        .calculator-keypad .clear-btn:active {
            background-color: #7a7a7a;
        }
        .amount-input {
            font-size: 32px;
            text-align: right;
            padding-right: 10px;
            height: 60px;
            position: relative;
            background-color: var(--input-bg);
            border: none;
            color: var(--input-text);
            margin-bottom: 10px;
        }
        .form-label {
            font-weight: 500;
            font-size: 14px;
            text-align: left;
            margin-bottom: 6px;
            color: var(--text-color);
        }
        .form-control, .form-select {
            font-size: 14px;
            height: 38px;
            padding: 8px;
            background-color: var(--input-bg);
            border: 1px solid var(--border-color);
            color: var(--input-text);
        }
        .description-input {
            background-color: var(--input-bg);
        }
        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            align-items: flex-start;
        }
        .form-row .col-md-3 {
            flex: 1 1 100%;
            max-width: 100%;
        }
        .btn-primary {
            font-size: 14px;
            padding: 8px 16px;
            width: 100%;
            margin-top: 15px;
            background-color: var(--button-bg);
            border: none;
        }
        .btn-primary:hover {
            background-color: var(--button-hover-bg);
        }
        @media (min-width: 768px) {
            .form-row .col-md-3 {
                flex: 1 1 24%;
                max-width: 24%;
            }
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: var(--nav-bg);
            color: var(--text-color);
            padding: 8px 0;
            box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.1);
            z-index: 1000;
        }
        .footer .nav {
            display: flex;
            justify-content: space-around;
            align-items: center;
            flex-wrap: nowrap;
            margin: 0;
            padding: 0 4px;
        }
        .footer .nav-link {
            color: var(--nav-link);
            font-size: 12px;
            padding: 6px 4px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            transition: background-color 0.2s, transform 0.1s;
            flex: 1;
            text-align: center;
            text-decoration: none;
        }
        .footer .nav-link:hover {
            background-color: var(--card-bg);
            transform: translateY(-1px);
            border-radius: 4px;
            color: var(--nav-link-hover);
        }
        .footer .nav-link.active {
            color: var(--nav-link-hover);
        }
        .footer .nav-link img {
            width: 25px;
            height: 25px;
            margin-bottom: 4px;
        }
        .footer .navimage img {
            width: 35px;
            height: 35px;
            margin-bottom: 4px;
        }
        @media (max-width: 576px) {
            .footer .nav-link {
                font-size: 10px;
                padding: 4px 2px;
            }
            .footer .nav-link img {
                margin-bottom: 2px;
            }
        }
        @media (max-width: 360px) {
            .footer .nav-link span {
                display: none;
            }
            .footer .nav-link img {
                margin-bottom: 0;
            }
        }
        .nav-tabs {
            border-bottom: none;
            margin-bottom: 0;
            background-color: var(--card-bg);
        }
        .nav-tabs .nav-link {
            border: none;
            border-radius: 0;
            color: var(--nav-link);
            padding: 12px 16px;
            font-size: 14px;
            font-weight: 500;
            background-color: transparent;
        }
        .nav-tabs .nav-link:hover {
            color: var(--nav-link-hover);
            background-color: var(--pagination-bg);
        }
        .nav-tabs .nav-link.active {
            color: var(--nav-link-hover);
            background-color: var(--bg-color);
            border-bottom: 2px solid var(--nav-link-hover);
        }
        .tab-pane {
            transition: opacity 0.15s ease-in-out;
        }
        .tab-pane {
            opacity: 0;
        }
        .tab-pane.show {
            opacity: 1;
        }
        .card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
        }
        .card-header {
            background-color: var(--nav-bg);
            color: var(--text-color);
        }
        .alert {
            background-color: var(--alert-bg);
            border: 1px solid var(--border-color);
            color: var(--text-color);
        }
        .alert-success {
            background-color: var(--alert-success-bg);
            border-color: var(--button-bg);
        }
        .alert-danger {
            background-color: var(--alert-danger-bg);
            border-color: #dc3545;
        }
        .navbar {
            background-color: var(--nav-bg);
        }
        .navbar-brand, .nav-link {
            color: var(--nav-link);
        }
        .navbar-brand:hover, .nav-link:hover {
            color: var(--nav-link-hover);
        }
        .auth-container {
            max-width: 400px;
            margin: 0 auto;
            padding: 20px;
            background-color: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .auth-container h2 {
            text-align: center;
            margin-bottom: 20px;
            color: var(--text-color);
        }
        .auth-container .btn-primary {
            background-color: var(--button-bg);
            border: none;
        }
        .auth-container .btn-primary:hover {
            background-color: var(--button-hover-bg);
        }
        .auth-container .form-control:focus {
            border-color: var(--button-bg);
            box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
        }
        .modal-content {
            background-color: var(--card-bg);
            color: var(--text-color);
        }
        .modal-header {
            border-bottom: 1px solid var(--border-color);
            color: var(--text-color);
        }
        .modal-footer {
            border-top: 1px solid var(--border-color);
        }
        .category-btn, .manba-btn, .supplier-btn {
            width: 100%;
            margin-bottom: 10px;
            background-color: var(--pagination-bg);
            color: var(--text-color);
        }
        .category-btn i, .manba-btn i, .supplier-btn i {
            margin-right: 8px;
        }
        .category-btn:hover, .manba-btn:hover, .supplier-btn:hover {
            background-color: var(--border-color);
        }
        .pagination {
            justify-content: center;
        }
        .page-item .page-link {
            background-color: var(--pagination-bg);
            border: 1px solid var(--border-color);
            color: var(--pagination-text);
            margin: 0 4px;
            border-radius: 4px;
            transition: background-color 0.2s, color 0.2s;
        }
        .page-item.active .page-link {
            background-color: var(--pagination-active-bg);
            border-color: var(--pagination-active-bg);
            color: #ffffff;
        }
        .page-item .page-link:hover {
            background-color: var(--card-bg);
            color: var(--nav-link-hover);
        }
        .page-item.disabled .page-link {
            background-color: var(--pagination-bg);
            border-color: var(--border-color);
            color: var(--pagination-disabled);
            cursor: not-allowed;
        }
        @media (max-width: 576px) {
            .pagination {
                flex-wrap: wrap;
            }
            .page-item .page-link {
                font-size: 12px;
                padding: 6px 10px;
            }
        }
        .theme-toggle {
            cursor: pointer;
            font-size: 20px;
            color: var(--nav-link);
        }
        .theme-toggle:hover {
            color: var(--nav-link-hover);
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Theme toggle functionality
            const html = document.documentElement;
            const themeToggle = document.getElementById('theme-toggle');
            const savedTheme = localStorage.getItem('theme') || 'dark';
            html.setAttribute('data-theme', savedTheme);
            updateThemeIcon(savedTheme);

            themeToggle.addEventListener('click', function() {
                const currentTheme = html.getAttribute('data-theme');
                const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
                html.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                updateThemeIcon(newTheme);
            });

            function updateThemeIcon(theme) {
                themeToggle.classList.remove(theme === 'dark' ? 'bi-sun' : 'bi-moon');
                themeToggle.classList.add(theme === 'dark' ? 'bi-moon' : 'bi-sun');
            }

            // Calculator keypad functionality
            document.querySelectorAll('.amount-input').forEach(input => {
                let currentValue = '0';
                let currentOperator = '';
                let previousValue = '0';
                const keypad = input.nextElementSibling;
                const form = input.closest('form');
                const hiddenInput = form.querySelector('input[name="amount"]');

                if (keypad && keypad.classList.contains('calculator-keypad')) {
                    keypad.querySelectorAll('button').forEach(button => {
                        button.addEventListener('click', function() {
                            const value = this.dataset.value || this.textContent;
                            let rawValue = currentValue.replace(/\s/g, '');

                            if (value === 'AC') {
                                currentValue = '0';
                                currentOperator = '';
                                previousValue = '0';
                                input.value = formatWithSpaces(currentValue);
                            } else if (value === '.' && !rawValue.includes('.')) {
                                currentValue += value;
                                input.value = formatWithSpaces(currentValue);
                            } else if (/[0-9]/.test(value)) {
                                currentValue = rawValue === '0' ? value : rawValue + value;
                                input.value = formatWithSpaces(currentValue);
                            } else if (value === '+/-') {
                                currentValue = (parseFloat(rawValue) * -1).toString();
                                input.value = formatWithSpaces(currentValue);
                            } else if (value === '%') {
                                currentValue = (parseFloat(rawValue) / 100).toString();
                                input.value = formatWithSpaces(currentValue);
                            } else if (['+', '-', '*', '/'].includes(value)) {
                                if (rawValue !== '') {
                                    if (previousValue === '0') {
                                        previousValue = rawValue;
                                    } else {
                                        previousValue = calculate(previousValue, rawValue, currentOperator);
                                    }
                                    currentOperator = value;
                                    currentValue = '0';
                                    input.value = formatWithSpaces(previousValue) + ' ' + currentOperator;
                                }
                            } else if (value === '=') {
                                if (previousValue !== '0' && rawValue !== '' && currentOperator !== '') {
                                    currentValue = calculate(previousValue, rawValue, currentOperator);
                                    input.value = formatWithSpaces(currentValue);
                                    previousValue = '0';
                                    currentOperator = '';
                                }
                            }

                            if (hiddenInput) {
                                hiddenInput.value = currentValue.replace(/\s/g, '');
                            }
                            console.log('Keypad Input', { display: input.value, raw: hiddenInput.value });
                        });
                    });
                }

                input.addEventListener('keydown', function(e) {
                    e.preventDefault();
                });
            });

            function calculate(a, b, op) {
                a = parseFloat(a);
                b = parseFloat(b);
                switch (op) {
                    case '+': return (a + b).toFixed(2);
                    case '-': return (a - b).toFixed(2);
                    case '*': return (a * b).toFixed(2);
                    case '/': return b !== 0 ? (a / b).toFixed(2) : 'Error';
                    default: return 'Error';
                }
            }

            function formatWithSpaces(num) {
                return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
            }

            // Modal handling
            document.querySelectorAll('.category-btn, .manba-btn, .supplier-btn').forEach(button => {
                button.addEventListener('click', function() {
                    const modalId = this.dataset.target + '-modal';
                    const modal = new bootstrap.Modal(document.getElementById(modalId));
                    modal.show();
                    console.log('Modal Triggered', { modalId: modalId });
                });
            });

            document.querySelectorAll('.option-btn').forEach(button => {
                button.addEventListener('click', function() {
                    const value = this.dataset.value;
                    const target = this.dataset.target;
                    const hiddenInput = document.getElementById(target);
                    const displayButton = document.querySelector(`[data-target="${target}"]`);
                    hiddenInput.value = value;
                    displayButton.textContent = this.textContent.trim();
                    const modal = bootstrap.Modal.getInstance(this.closest('.modal'));
                    modal.hide();
                    console.log('Option Selected', { target: target, value: value });
                });
            });
        });
    </script>
</head>
<body>
<nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand" href="{{ route('dashboard') }}">
                <img src="https://paypul.datamax.uz/paypullogo.png" width="100" height="45" alt="PayPul Logo">
            </a>
            <button class="navbar-toggler" type="button" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <button id="theme-toggle" class="nav-link theme-toggle">
                        </button>
                    </li>
                </ul>
                @auth
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('profile.edit') }}">{{ auth()->user()->name }}</a>
                        </li>
                        <li class="nav-item">
                            <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                                @csrf
                                <button type="submit" class="nav-link btn btn-link">Chiqish</button>
                            </form>
                        </li>
                    </ul>
                @endauth
            </div>
        </div>
    </nav>

    <div class="content">
        <div class="container mt-4">
            @yield('content')
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <ul class="nav">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('history.index') ? 'active' : '' }}" href="{{ route('history.index') }}">
                        <img src="https://img.icons8.com/?size=96&id=86125&format=png&color=40C057" alt="History Icon">
                        <span></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('analytics.index') ? 'active' : '' }}" href="{{ route('analytics.index') }}">
                        <img src="https://img.icons8.com/?size=24&id=83248&format=png&color=40C057" alt="Analytics Icon">
                        <span></span>
                    </a>
                </li>
                <li class="navimage">
                    <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                        <img src="https://img.icons8.com/?size=100&id=37839&format=png&color=40C057" alt="Dashboard Icon">
                        <span></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('suppliers.index') ? 'active' : '' }}" href="{{ route('suppliers.index') }}">
                        <img src="https://img.icons8.com/?size=96&id=89624&format=png&color=40C057" alt="Supplier Icon">
                        <span></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('categories.index') ? 'active' : '' }}" href="{{ route('categories.index') }}">
                        <img src="https://img.icons8.com/?size=60&id=61180&format=png&color=40C057" alt="Category Icon">
                        <span></span>
                    </a>
                </li>
            </ul>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Navbar toggle fix -->
 <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Navbar toggle
            const navbarToggler = document.querySelector('.navbar-toggler');
            const navbarCollapse = document.querySelector('#navbarNav');

            navbarToggler.addEventListener('click', function () {
                if (navbarCollapse.style.display === 'block') {
                    navbarCollapse.style.display = 'none';
                    navbarToggler.setAttribute('aria-expanded', 'false');
                } else {
                    navbarCollapse.style.display = 'block';
                    navbarToggler.setAttribute('aria-expanded', 'true');
                }
            });

            // Reset navbar on window resize
            window.addEventListener('resize', function () {
                if (window.innerWidth >= 992) { // Bootstrap lg breakpoint
                    navbarCollapse.style.display = 'flex';
                } else if (navbarToggler.getAttribute('aria-expanded') !== 'true') {
                    navbarCollapse.style.display = 'none';
                }
            });

            // Initialize navbar state
            if (window.innerWidth >= 992) {
                navbarCollapse.style.display = 'flex';
            } else {
                navbarCollapse.style.display = 'none';
            }

            
        });
    </script>
</body>
</html>