@extends('layouts.app')
@section('title', 'Yetkazib beruvchiga to‘lovlar')
@section('content')
<div class="container">
    <h2 class="mb-4">Yetkazib beruvchiga to‘lovlar</h2>
    <a href="{{ route('payments-to-supplier.create') }}" class="btn btn-primary mb-3">Yangi to‘lov qo‘shish</a>
    <div class="card">
        <div class="card-body">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Yetkazib beruvchi</th>
                        <th>Miqdor (so'm)</th>
                        <th>Manba</th>
                        <th>Tavsif</th>
                        <th>Sana</th>
                        <th>Amallar</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($payments as $payment)
                    <tr>
                        <td>{{ $payment->supplier->name }}</td>
                        <td class="format-number">{{ $payment->amount }}</td>
                        <td>{{ $payment->source == 'cash' ? 'Naqd' : 'Karta' }}</td>
                        <td>{{ $payment->description ?? '-' }}</td>
                        <td>{{ $payment->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('payments-to-supplier.edit', $payment->id) }}" class="btn btn-sm btn-primary">Tahrirlash</a>
                            <form action="{{ route('payments-to-supplier.destroy', $payment->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('O‘chirishni tasdiqlaysizmi?')">O‘chirish</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center">Hozircha to‘lovlar yo‘q</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection