@extends('layouts.app')
@section('title', 'Yangi yetkazib beruvchi qo‘shish')

@section('content')
<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Yangi yetkazib beruvchi qo‘shish</h5>
        </div>
        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('suppliers.store') }}">
                @csrf
                <div class="mb-3">
                    <label for="name" class="form-label">Ism:</label>
                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="phone" class="form-label">Telefon (ixtiyoriy):</label>
                    <input type="text" name="phone" id="phone" class="form-control @error('phone') is-invalid @enderror" value="{{ old('phone') }}">
                    @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="debt_balance" class="form-label">Qarz miqdori (so‘m):</label>
                    <input type="number" name="debt_balance" id="debt_balance" class="form-control @error('debt_balance') is-invalid @enderror" value="{{ old('debt_balance', 0) }}" min="0" step="0.01" required>
                    @error('debt_balance')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Qarz holati:</label>
                    <div class="form-check">
                        <input type="radio" name="debt_type" id="we_owe" value="we_owe" class="form-check-input @error('debt_type') is-invalid @enderror" {{ old('debt_type') == 'we_owe' ? 'checked' : '' }}>
                        <label for="we_owe" class="form-label">Biz qarzdormiz</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" name="debt_type" id="they_owe" value="they_owe" class="form-check-input @error('debt_type') is-invalid @enderror" {{ old('debt_type') == 'they_owe' ? 'checked' : '' }}>
                        <label for="they_owe" class="form-label">Yetkazib beruvchi qarzdor</label>
                    </div>
                    @error('debt_type')
                        <div class="invalid-feedback d-block">{{ $message }}</div>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary">Saqlash</button>
                <a href="{{ route('suppliers.index') }}" class="btn btn-secondary">Bekor qilish</a>
            </form>
        </div>
    </div>
</div>

<script>
    // Radio tugmalarni faqat debt_balance > 0 bo‘lganda majburiy qilish
    document.getElementById('debt_balance').addEventListener('input', function() {
        const debtBalance = parseFloat(this.value);
        const radioButtons = document.querySelectorAll('input[name="debt_type"]');
        radioButtons.forEach(radio => {
            radio.required = debtBalance > 0;
        });
    });
</script>
@endsection