@extends('layouts.app')
@section('title', 'Yetkazib beruvchi tafsilotlari')

@section('content')
<style>
    .image-grid img {
        max-width: 100px;
        margin: 5px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: transform 0.2s;
    }
    .image-grid img:hover {
        transform: scale(1.05);
    }
    #fullscreen-image {
        max-width: 100%;
        max-height: 80vh;
        object-fit: contain;
    }
    .pagination .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-text);
        border-color: var(--border-color);
        transition: background-color 0.2s, color 0.2s;
    }
    .pagination .page-link:hover {
        background-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.active .page-link {
        background-color: var(--pagination-active-bg);
        border-color: var(--pagination-active-bg);
        color: var(--input-text);
    }
    .pagination .page-item.disabled .page-link {
        background-color: var(--pagination-bg);
        color: var(--pagination-disabled);
        border-color: var(--border-color);
    }
    .phone-link {
        color: var(--text-color);
        text-decoration: none;
    }
    .phone-link:hover {
        text-decoration: underline;
        color: var(--pagination-active-bg);
    }
</style>

<div class="container mt-4">
    <div class="card" style="background-color: var(--card-bg); border: 1px solid var(--border-color);">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0" style="color: var(--text-color);">Yetkazib beruvchi tafsilotlari</h5>
            <div>
                @if (auth()->user()->isAdmin() || auth()->user()->id == $supplier->user_id)
                    <a href="{{ route('suppliers.edit', $supplier->id) }}" class="btn btn-primary btn-sm" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Tahrirlash</a>
                @endif
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#returnProductModal" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Mahsulotni qaytarish</button>
            </div>
        </div>
        <div class="card-body">
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert" style="background-color: var(--alert-success-bg); color: var(--text-color);">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert" style="background-color: var(--alert-danger-bg); color: var(--text-color);">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="mb-3">
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Nomi:</strong> {{ $supplier->name }}</p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Telefon:</strong> 
                    @if ($supplier->phone)
                        <a href="tel:{{ $supplier->phone }}" class="phone-link">{{ $supplier->phone }}</a>
                    @else
                        N/A
                    @endif
                </p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Qarz holati:</strong>
                    @if ($supplier->debt_balance == 0)
                        Qarz yo‘q
                    @elseif ($supplier->debt_balance > 0)
                        {{ number_format($supplier->debt_balance, 2, '.', ' ') }} so‘m
                    @else
                        {{ number_format(abs($supplier->debt_balance), 2, '.', ' ') }} so‘m
                    @endif
                </p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Biriktirilgan:</strong> {{ $supplier->user->name ?? 'N/A' }}</p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Yaratilgan sana:</strong> {{ $supplier->created_at->format('d.m.Y H:i') }}</p>
                <p style="color: var(--text-color);"><strong style="color: var(--text-color);">Yangilangan sana:</strong> {{ $supplier->updated_at->format('d.m.Y H:i') }}</p>
            </div>

            <div class="modal fade" id="returnProductModal" tabindex="-1" aria-labelledby="returnProductModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                        <div class="modal-header">
                            <h5 class="modal-title" id="returnProductModalLabel" style="color: var(--text-color);">Mahsulotni qaytarish</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{ route('suppliers.return-product', $supplier->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label for="amount" class="form-label" style="color: var(--text-color);">Qaytariladigan summa (so‘m):</label>
                                    <input type="number" class="form-control" id="amount" name="amount" step="0.01" min="0.01" max="1000000" required style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);">
                                    @error('amount')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="description" class="form-label" style="color: var(--text-color);">Izoh:</label>
                                    <textarea class="form-control" id="description" name="description" rows="4" style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);"></textarea>
                                    @error('description')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="images" class="form-label" style="color: var(--text-color);">Rasmlar (maksimum 5 ta):</label>
                                    <input type="file" class="form-control" id="images" name="images[]" accept="image/jpeg,image/png,image/jpg" multiple style="background-color: var(--input-bg); color: var(--input-text); border-color: var(--border-color);">
                                    @error('images.*')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                <button type="submit" class="btn btn-primary">Saqlash</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            @if ($operations->isNotEmpty())
                <h5 style="color: var(--text-color);">Amaliyotlar tarixi</h5>
                @foreach ($operations as $operation)
                    <div class="card mb-2" style="background-color: var(--card-bg); border-color: var(--border-color);" data-bs-toggle="modal" data-bs-target="#operationModal{{ $operation->source_table }}_{{ $operation->id }}">
                        <div class="card-body p-3 d-flex align-items-center" style="cursor: pointer;">
                            <img src="{{ asset('assets/icons/' . ($operation->source_table == 'transactions' ? ($operation->type == 'product_return' ? 'product_return.png' : 'expense.png') : ($operation->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png'))) }}" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong style="color: var(--text-color);">
                                    @if ($operation->source_table == 'transactions')
                                        {{ $operation->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat' }}
                                    @else
                                        {{ $operation->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi' }}
                                    @endif
                                    @if ($operation->source_table == 'payments' && $operation->is_cancelled)
                                        <span class="badge bg-danger">Bekor qilindi</span>
                                    @endif
                                </strong>
                                <div class="{{ $operation->amount >= 0 ? 'text-success' : 'text-danger' }}" style="color: {{ $operation->amount >= 0 ? 'var(--success-color)' : 'var(--danger-color)' }};">
                                    {{ number_format(abs($operation->amount), 2, '.', ' ') }} so‘m
                                </div>
                                <small class="text-muted" style="color: var(--text-muted);">
                                    {{ $operation->created_at->format('d.m.Y H:i') }}
                                    @if ($operation->user)
                                        | {{ $operation->user->name }}
                                    @endif
                                </small>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="operationModal{{ $operation->source_table }}_{{ $operation->id }}" tabindex="-1" aria-labelledby="operationModalLabel{{ $operation->source_table }}_{{ $operation->id }}" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="operationModalLabel{{ $operation->source_table }}_{{ $operation->id }}" style="color: var(--text-color);">
                                        @if ($operation->source_table == 'transactions')
                                            {{ $operation->type == 'product_return' ? 'Mahsulot qaytarish' : 'Xarajat' }}
                                        @else
                                            {{ $operation->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot kirimi' }}
                                        @endif
                                    </h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body" style="color: var(--text-color);">
                                    <p><strong>Sana:</strong> {{ $operation->created_at->format('d.m.Y H:i') }}</p>
                                    <p><strong>Summa:</strong> {{ number_format(abs($operation->amount), 2, '.', ' ') }} so‘m</p>
                                    @if ($operation->type == 'payment_to_supplier')
                                        <p><strong>Manba:</strong> {{ $operation->source == 'cash' ? 'Naqd' : 'Karta' }}</p>
                                    @endif
                                    <p><strong>Izoh:</strong> {{ $operation->description ?? 'Izoh yo‘q' }}</p>
                                    <p><strong>Rasmlar:</strong>
                                        @php
                                            $images = $operation->images ? json_decode($operation->images, true) : [];
                                        @endphp
                                        @if (!empty($images) && is_array($images))
                                            <div class="image-grid d-flex flex-wrap">
                                                @foreach ($images as $index => $image)
                                                    <img src="{{ asset('storage/' . $image) }}" alt="Rasm" data-bs-toggle="modal" data-bs-target="#fullscreenModal{{ $operation->source_table }}_{{ $operation->id }}_{{ $index }}">
                                                @endforeach
                                            </div>
                                        @else
                                            Rasm yuklanmagan
                                        @endif
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    @if (auth()->user()->isAdmin() && $operation->source_table == 'payments' && !$operation->is_cancelled)
                                        <form action="{{ route('payments.cancel', $operation->id) }}" method="POST">
                                            @csrf
                                            @method('POST')
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    @endif
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if (!empty($images) && is_array($images))
                        @foreach ($images as $index => $image)
                            <div class="modal fade" id="fullscreenModal{{ $operation->source_table }}_{{ $operation->id }}_{{ $index }}" tabindex="-1" aria-labelledby="fullscreenModalLabel{{ $operation->source_table }}_{{ $operation->id }}_{{ $index }}" aria-hidden="true">
                                <div class="modal-dialog modal-fullscreen-sm-down">
                                    <div class="modal-content" style="background-color: var(--card-bg); border-color: var(--border-color);">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="fullscreenModalLabel{{ $operation->source_table }}_{{ $operation->id }}_{{ $index }}" style="color: var(--text-color);">Rasm</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body text-center">
                                            <img id="fullscreen-image" src="{{ asset('storage/' . $image) }}" alt="Rasm">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                @endforeach

                <div class="mt-3 d-flex justify-content-center">
                    {{ $operations->links('pagination::bootstrap-5') }}
                </div>
            @else
                <div class="text-center" style="color: var(--text-color);">Hozircha amaliyotlar yo‘q</div>
            @endif

            <a href="{{ route('suppliers.index') }}" class="btn btn-primary mt-3" style="background-color: var(--button-bg); color: var(--input-text); border: none;">Orqaga</a>
        </div>
    </div>
</div>
@endsection