@extends('layouts.app')
@section('title', 'Tranzit xarajatlar')
@section('content')
<div class="container">
    <h2 class="mb-4">Tranzit xarajatlar</h2>
    <a href="{{ route('transit-expenses.create') }}" class="btn btn-primary mb-3">Yangi xarajat qo‘shish</a>
    <div class="card">
        <div class="card-body">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Miqdor (so'm)</th>
                        <th>Manba</th>
                        <th>Tavsif</th>
                        <th>Sana</th>
                        <th>Amallar</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($expenses as $expense)
                    <tr>
                        <td class="format-number">{{ $expense->amount }}</td>
                        <td>{{ $expense->source == 'cash' ? 'Naqd' : 'Karta' }}</td>
                        <td>{{ $expense->description ?? '-' }}</td>
                        <td>{{ $expense->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            <a href="{{ route('transit-expenses.edit', $expense->id) }}" class="btn btn-sm btn-primary">Tahrirlash</a>
                            <form action="{{ route('transit-expenses.destroy', $expense->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('O‘chirishni tasdiqlaysizmi?')">O‘chirish</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">Hozircha xarajatlar yo‘q</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection