
<?php $__env->startSection('title', 'Yetkazib beruvchilar'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .list-group-item {
        transition: all 0.2s ease;
        border-radius: 8px !important;
        margin-bottom: 12px;
        border: 1px solid #dee2e6;
        padding: 15px;
        background-color: var(--bs-body-bg, #fff);
        color: var(--bs-body-color, #212529);
    }
    .list-group-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.05);
        background-color: var(--bs-light, #f8f9fa);
    }
    .supplier-name {
        font-size: 1.1rem;
        font-weight: 500;
    }
    .supplier-balance {
        font-size: 1rem;
        font-weight: 600;
    }
    [data-bs-theme="dark"] .list-group-item {
        background-color: #343a40;
        border-color: #495057;
        color: #f8f9fa;
    }
    [data-bs-theme="dark"] .list-group-item:hover {
        background-color: #495057;
        box-shadow: 0 3px 6px rgba(0, 0, 0, 0.2);
    }
    @media (max-width: 576px) {
        .list-group-item {
            padding: 12px;
        }
        .supplier-name {
            font-size: 0.95rem;
        }
        .supplier-balance {
            font-size: 0.9rem;
        }
    }
</style>

<div class="container mt-4">
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
               Balans: 
                <span class="text-danger">Qarzdorlik: <?php echo e(number_format(abs($weOweBalance), 0, '.', ' ')); ?> so‘m</span>
                <span class="text-success"> | Qoldiq: <?php echo e(number_format($theyOweBalance, 0, '.', ' ')); ?> so‘m</span>
            </h5>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <button class="btn btn-outline-primary btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse" id="filterToggleBtn">
                Filtrlarni ko‘rsatish
            </button>
        </div>
        <div class="collapse" id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('suppliers.index')); ?>">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="user_id" class="form-label">Biriktirilgan shaxs</label>
                            <select name="user_id" id="user_id" class="form-control">
                                <option value="">Hammasi</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="debt_type" class="form-label">Qarz holati</label>
                            <select name="debt_type" id="debt_type" class="form-control">
                                <option value="">Hammasi</option>
                                <option value="we_owe" <?php echo e(request('debt_type') == 'we_owe' ? 'selected' : ''); ?>>Qarzmiz</option>
                                <option value="they_owe" <?php echo e(request('debt_type') == 'they_owe' ? 'selected' : ''); ?>>Qarz emasmiz</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="date" class="form-label">Sana (dan boshlab)</label>
                            <input type="date" name="date" id="date" class="form-control" value="<?php echo e(request('date')); ?>">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary btn-sm">Filtrlash</button>
                        <a href="<?php echo e(route('suppliers.index')); ?>" class="btn btn-secondary btn-sm">Tozalash</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Yetkazib beruvchilar ro‘yxati</h5>
            <a href="<?php echo e(route('suppliers.create')); ?>" class="btn btn-primary btn-sm float-end">Yangi qo‘shish</a>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="list-group">
                <?php $__empty_1 = true; $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('suppliers.show', $supplier->id)); ?>" class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between align-items-center">
                            <h5 class="mb-0 supplier-name"><?php echo e($supplier->name); ?></h5>
                            <span class="supplier-balance <?php echo e($supplier->debt_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e(number_format($supplier->debt_balance, 0, '.', ' ')); ?> so‘m
                            </span>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="list-group-item text-center">
                        Yetkazib beruvchilar topilmadi
                    </div>
                <?php endif; ?>
            </div>

            <div class="mt-4">
                <?php echo e($suppliers->appends(request()->query())->links('pagination::bootstrap-5-custom')); ?>

            </div><br><br><br>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const filterToggleBtn = document.getElementById('filterToggleBtn');
        const filterCollapse = document.getElementById('filterCollapse');

        filterCollapse.addEventListener('show.bs.collapse', function () {
            filterToggleBtn.textContent = 'Filtrlarni yashirish';
        });

        filterCollapse.addEventListener('hide.bs.collapse', function () {
            filterToggleBtn.textContent = 'Filtrlarni ko‘rsatish';
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/festasystems/paypul.datamax.uz/resources/views/suppliers/index.blade.php ENDPATH**/ ?>