
<?php $__env->startSection('title', 'Yetkazib beruvchi tafsilotlari'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Yetkazib beruvchi tafsilotlari</h5>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="mb-3">
                <p><strong>Nomi:</strong> <?php echo e($supplier->name); ?></p>
                <p><strong>Telefon:</strong> <?php echo e($supplier->phone ?? 'N/A'); ?></p>
                <p><strong>Qarz holati:</strong> 
                    <?php if($supplier->debt_balance == 0): ?>
                        Qarz yo‘q
                    <?php elseif($supplier->debt_balance > 0): ?>
                        Yetkazib beruvchi qarzdor: <?php echo e(number_format($supplier->debt_balance, 2)); ?> so‘m
                    <?php else: ?>
                        Biz qarzdormiz: <?php echo e(number_format(abs($supplier->debt_balance), 2)); ?> so‘m
                    <?php endif; ?>
                </p>
                <p><strong>Biriktirilgan:</strong> <?php echo e($supplier->user->name ?? 'N/A'); ?></p>
                <p><strong>Yaratilgan sana:</strong> <?php echo e($supplier->created_at->format('d.m.Y H:i')); ?></p>
                <p><strong>Yangilangan sana:</strong> <?php echo e($supplier->updated_at->format('d.m.Y H:i')); ?></p>
            </div>

            <h5 class="mt-4 mb-3">Tranzaksiyalar tarixi</h5>
            <?php if($supplier->payments->isEmpty()): ?>
                <p class="text-muted">Ushbu yetkazib beruvchi uchun tranzaksiyalar yo‘q.</p>
            <?php else: ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Turi</th>
                            <th>Miqdori</th>
                            <th>Manba</th>
                            <th>Tavsif</th>
                            <th>Sana</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $supplier->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($payment->type == 'payment_to_supplier'): ?>
                                        Yetkazib beruvchiga to‘lov
                                    <?php elseif($payment->type == 'product_payment'): ?>
                                        Mahsulot uchun to‘lov
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($payment->amount, 2)); ?> so‘m</td>
                                <td><?php echo e($payment->source ? ucfirst($payment->source) : 'N/A'); ?></td>
                                <td><?php echo e($payment->description ?? 'N/A'); ?></td>
                                <td><?php echo e($payment->created_at->format('d.m.Y H:i')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php endif; ?>

            <a href="<?php echo e(route('suppliers.index')); ?>" class="btn btn-primary">Orqaga</a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH K:\XAX\htdocs\paypul\resources\views/suppliers/show.blade.php ENDPATH**/ ?>