
<?php $__env->startSection('title', 'Tarix'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .image-grid img {
        max-width: 100px;
        margin: 5px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        cursor: pointer;
        transition: transform 0.2s;
    }
    .image-grid img:hover {
        transform: scale(1.05);
    }
    #fullscreen-image {
        max-width: 100%;
        max-height: 80vh;
        object-fit: contain;
    }
</style>

<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Barcha amaliyotlar tarixi</h5>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card mb-2" data-bs-toggle="modal" data-bs-target="#historyModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>">
                    <div class="card-body p-3" style="cursor: pointer;">
                        <div class="d-flex align-items-center">
                            <img src="<?php echo e(asset('assets/icons/' . ($item->source_table == 'transactions' ? ($item->type == 'income' ? 'income.png' : 'expense.png') : ($item->type == 'payment_to_supplier' ? 'payment_to_supplier.png' : 'product_payment.png')))); ?>" alt="Icon" style="width: 24px; height: 24px; margin-right: 12px;">
                            <div>
                                <strong>
                                    <?php if($item->source_table == 'transactions'): ?>
                                        <?php echo e($item->type == 'income' ? 'Kirim' : 'Xarajat'); ?>

                                    <?php else: ?>
                                        <?php echo e($item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot to‘lovi'); ?>

                                    <?php endif; ?>
                                    <?php if($item->is_cancelled): ?>
                                        <span class="badge bg-danger">Bekor qilindi</span>
                                    <?php endif; ?>
                                </strong>
                                <div class="<?php echo e($item->amount >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e(number_format($item->amount, 2, '.', ' ')); ?> so‘m
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="historyModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="historyModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>" aria-hidden="true">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="historyModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>">Amaliyot tafsilotlari</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p><strong>Turi:</strong>
                                    <span>
                                        <?php if($item->source_table == 'transactions'): ?>
                                            <?php echo e($item->type == 'income' ? 'Kirim' : 'Xarajat'); ?>

                                        <?php else: ?>
                                            <?php echo e($item->type == 'payment_to_supplier' ? 'Yetkazib beruvchiga to‘lov' : 'Mahsulot to‘lovi'); ?>

                                        <?php endif; ?>
                                        <?php if($item->is_cancelled): ?>
                                            <span class="badge bg-danger">Bekor qilindi</span>
                                        <?php endif; ?>
                                    </span>
                                </p>
                                <p><strong>Miqdor:</strong>
                                    <span class="<?php echo e($item->amount >= 0 ? 'text-success' : 'text-danger'); ?>"><?php echo e(number_format($item->amount, 2, '.', ' ')); ?> so‘m</span>
                                </p>
                                <p><strong>Manba:</strong>
                                    <span><?php echo e($item->source ? ($item->source == 'cash' ? 'Naqd' : 'Karta') : 'N/A'); ?></span>
                                </p>
                                <p><strong>Yetkazib beruvchi:</strong>
                                    <span><?php echo e($item->supplier_name ?? 'N/A'); ?></span>
                                </p>
                                <p><strong>Qarz:</strong>
                                    <span>
                                        <?php if($item->supplier && $item->supplier->debt_balance == 0): ?>
                                            Qarz yo‘q
                                        <?php elseif($item->supplier && $item->supplier->debt_balance > 0): ?>
                                            Yetkazib beruvchi qarzdor: <?php echo e(number_format($item->supplier->debt_balance, 2, '.', ' ')); ?> so‘m
                                        <?php elseif($item->supplier): ?>
                                            Biz qarzdormiz: <?php echo e(number_format(abs($item->supplier->debt_balance), 2, '.', ' ')); ?> so‘m
                                        <?php else: ?>
                                            N/A
                                        <?php endif; ?>
                                    </span>
                                </p>
                                <p><strong>Kategoriya:</strong>
                                    <span><?php echo e($item->related_entity ?? 'N/A'); ?></span>
                                </p>
                                <p><strong>Foydalanuvchi:</strong>
                                    <span><?php echo e($item->user_name ?? 'N/A'); ?></span>
                                </p>
                                <p><strong>Tavsif:</strong>
                                    <span><?php echo e($item->description ?? 'N/A'); ?></span>
                                </p>
                                <p><strong>Sana:</strong>
                                    <span><?php echo e($item->created_at->format('Y-m-d H:i')); ?></span>
                                </p>
                                <?php if($item->is_cancelled): ?>
                                    <p><strong>Bekor qilingan sana:</strong>
                                        <span><?php echo e($item->cancelled_at->format('Y-m-d H:i')); ?></span>
                                    </p>
                                <?php endif; ?>
                                <p><strong>Rasmlar:</strong>
                                    <?php
                                        $images = $item->images ? json_decode($item->images, true) : [];
                                    ?>
                                    <?php if(!empty($images) && is_array($images)): ?>
                                        <div class="image-grid d-flex flex-wrap">
                                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm" data-bs-toggle="modal" data-bs-target="#fullscreenModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>">
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php else: ?>
                                        Rasm yuklanmagan
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="modal-footer">
                                <?php if(auth()->user()->isAdmin() && !$item->is_cancelled): ?>
                                    <?php if($item->source_table == 'transactions' && $item->type != 'income'): ?>
                                        <form action="<?php echo e(route('transactions.cancel', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    <?php elseif($item->source_table == 'payments' && $item->type == 'payment_to_supplier'): ?>
                                        <form action="<?php echo e(route('payments.cancel', $item->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('POST'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm">Bekor qilish</button>
                                        </form>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                    $images = $item->images ? json_decode($item->images, true) : [];
                ?>
                <?php if(!empty($images) && is_array($images)): ?>
                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modal fade" id="fullscreenModal<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>" tabindex="-1" aria-labelledby="fullscreenModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>" aria-hidden="true">
                            <div class="modal-dialog modal-fullscreen-sm-down">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="fullscreenModalLabel<?php echo e($item->source_table); ?>_<?php echo e($item->id); ?>_<?php echo e($index); ?>">Rasm</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <img id="fullscreen-image" src="<?php echo e(asset('storage/' . $image)); ?>" alt="Rasm">
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Yopish</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center">Hozircha amaliyotlar yo‘q</div>
            <?php endif; ?>

            <div class="mt-3">
                <?php echo e($results->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH K:\XAX\htdocs\paypul\resources\views/history/index.blade.php ENDPATH**/ ?>